/**
* \file: AlsaAudioSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_ALSAAUDIOSOURCE_H
#define AAUTO_ALSAAUDIOSOURCE_H

#include "aauto/AditAudioSource.h"

namespace adit { namespace aauto {

/* forward declaration of internal implementation */
class AlsaAudioSourceImpl;

/** 
 * @brief AlsaAudioSource provides ALSA specific audio source implementation.*/
class AlsaAudioSource : public AditAudioSource
{
public:
    /**
     * @brief  Constructor of AlsaAudioSource
     * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
     * @param  inMessageRouter  inMessageRouter is message router obtained from GalReceiver.
     * @param  inCodec          inCodec is media codec type in GalReceiver.
     *                          (current GalReceiver is fixed "MEDIA_CODEC_AUDIO_PCM") */
    AlsaAudioSource(uint8_t inSessionId, MessageRouter* inMessageRouter, int inCodec);
    virtual ~AlsaAudioSource();

    /**
     * @brief Initialize the AlsaAudioSource. All configuration items must be set.
     *
     * @return true if initialization succeeds.
     *          false if configuration items without default value is not set or initialization
     *          fails. */
    bool init();

    /**
     * @brief  Shutdown the Alsa Audio Source */
    void shutdown();

    /** @brief Set configuration for platform and AudioSource-related items.
     * Must be called before init().
     * @param  inKey        The key string for configuration (e.g. "alsa-main-audio-in")
     *  - [ALSA Configuration]
     *  - alsa-main-audio-in [mandatory] :          Defines the ALSA device name to be used and
     *                                              also 3 parameters: periodMs, bufferPeriods, and silenceMs.
     * <pre>
     *     device [mandatory]                           ALSA device name.
     *     periodMs [mandatory]                         size of one period in milliseconds.
     *     bufferPeriods [optional, default=3]          number of periods in the audio buffer of the adapter.
     *                                                  The buffer size will be extended internally
     *                                                  if it can't fit (silenceMs + periodMs)
     *                                                  to hold at least (silenceMs + periodMs).
     *     silenceMs [optional, default=2x periodMs]    length of 0 prefill in the audio buffer to
     *                                                  avoid buffer underrun at the cost of latency.
     * </pre>
     * @param  inValue      The actual value for configuration (e.g. "device=Microphone periodMs=8")
     * */
    void setConfigItem(string inKey, string inValue);

    /**
     * @brief Register callback interface to receive AudioSource-related notifications.
     * See IAditAudioSourceCallbacks for details.
     *
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditAudioSourceCallbacks* inCallbacks);

private:
    AlsaAudioSourceImpl* impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ALSAAUDIOSOURCE_H */
